import layoutHeaderAside from '@/layout/header-aside'

// 由于懒加载页面太多的话会造成webpack热更新太慢，所以开发环境不使用懒加载，只有生产环境使用懒加载
const _import = require('@/libs/util.import.' + process.env.NODE_ENV)

/**
 * 在主框架内显示
 */
const frameIn = [
  {
    path: '/',
    redirect: { name: 'index' },
    component: layoutHeaderAside,
    children: [
      // 首页
      {
        path: 'index',
        name: 'index',
        meta: {
          auth: true
        },
        component: _import('homePage/index')
      },
      // 客户
      // 客户 列表
      {
        path: 'customerList',
        name: 'customerList',
        meta: {
          title: '客户列表',
          auth: true

        },
        component: _import('customer/list/index')
      },
      // 添加 客户
      {
        path: 'addCustomer',
        name: 'addCustomer',
        meta: {
          title: '添加客户',
          auth: true

        },
        component: _import('customer/add/index')
      },
      // 产品
      // 添加 产品
      {
        path: 'addProduct',
        name: 'addProduct',
        meta: {
          title: '添加产品',
          auth: true

        },
        component: _import('product/add/index')
      },
      // 编辑 产品
      {
        path: 'editProduct/:id',
        name: 'editProduct/:id',
        meta: {
          title: '编辑产品',
          auth: true

        },
        component: _import('product/add/index')
      },
      // 产品 列表
      {
        path: 'productList',
        name: 'productList',
        meta: {
          title: '产品列表',
          auth: true

        },
        component: _import('product/list/index')
      },
      // 采购单
      // 采购单 列表
      {
        path: 'purchaseOrderList',
        name: 'purchaseOrderList',
        meta: {
          title: '采购单列表',
          auth: true

        },
        component: _import('purchaseOrder/list/index')
      },
      // 添加 采购单
      {
        path: 'addPurchaseOrder',
        name: 'addPurchaseOrder',
        meta: {
          title: '添加采购单',
          auth: true

        },
        component: _import('purchaseOrder/add/index')
      },
      // 商家 列表
      {
        path: 'businessList',
        name: 'businessList',
        meta: {
          title: '商家列表',
          auth: true

        },
        component: _import('business/list/index')
      },
      // 添加 商家
      {
        path: 'addBusiness',
        name: 'addBusiness',
        meta: {
          title: '添加商家',
          auth: true
        },
        component: _import('business/add/index')
      },
      // 编辑 商家
      {
        path: 'editBusiness/:id',
        name: 'editBusiness/:id',
        meta: {
          title: '编辑商家',
          auth: true
        },
        component: _import('business/add/index')
      },
      // 详情
      {
        path: 'detailsBusiness/:id',
        name: 'detailsBusiness/:id',
        meta: {
          title: '商家信息',
          auth: true
        },
        component: _import('business/details/index')
      },
      // 基本信息 设置
      {
        path: 'basicModiy/:id',
        name: 'basicModiy/:id',
        meta: {
          title: '基本信息编辑',
          auth: true
        },
        component: _import('business/details/modiy/basic/index')
      },
      // 联系信息 设置
      {
        path: 'contactModiy/:id',
        name: 'contactModiy/:id',
        meta: {
          title: '联系信息编辑',
          auth: true
        },
        component: _import('business/details/modiy/contact/index')
      },
      // 收款信息 设置
      {
        path: 'chargeModiy/:id',
        name: 'chargeModiy/:id',
        meta: {
          title: '收款信息编辑',
          auth: true
        },
        component: _import('business/details/modiy/charge/index')
      },
      // 商家介绍
      {
        path: 'businessIntroduce/:id',
        name: 'businessIntroduce/:id',
        meta: {
          title: '商家介绍',
          auth: true
        },
        component: _import('business/details/introduce/index')
      },

      // 刷新页面 必须保留
      {
        path: 'refresh',
        name: 'refresh',
        hidden: true,
        component: _import('system/function/refresh')
      },
      // 页面重定向 必须保留
      {
        path: 'redirect/:route*',
        name: 'redirect',
        hidden: true,
        component: _import('system/function/redirect')
      }
    ]
  }
]

/**
 * 在主框架之外显示
 */
const frameOut = [
  // 登录
  {
    path: '/login',
    name: 'login',
    component: _import('system/login')
  }
]

/**
 * 错误页面
 */
const errorPage = [
  {
    path: '*',
    name: '404',
    component: _import('system/error/404')
  }
]

// 导出需要显示菜单的
export const frameInRoutes = frameIn

// 重新组织后导出
export default [
  ...frameIn,
  ...frameOut,
  ...errorPage
]
