// import api from '@/api'
export function debounce (fn, delay) {
    let timer
    return function () {
      const args = arguments
      if (timer) {
        clearTimeout(timer)
      }
      timer = setTimeout(() => {
        timer = null
        fn.apply(this, args)
      }, delay)
    }
  }
  
  export function throttle (fn, delay) {
    let prev = Date.now()
    return function () {
      const now = Date.now()
      if (now - prev > delay) {
        fn()
        prev = Date.now()
      }
    }
  }
  
  // export function getOlderType() {
  //   const res = api.GET_OLDER_TYPE()
  //   console.log(res)
  // }
  export function getCurrentDate () {
    const d = new Date()
    let str = ''
    str += d.getFullYear() + '-' // 获取当前年份
    str += d.getMonth() + 1 + '-' // 获取当前月份（0——11）
    str += d.getDate() + ' '
    str += d.getHours() + ':'
    str += d.getMinutes() + ':'
    str += d.getSeconds() + ':'
    return str
  }
  
  export function filterParams (obj) {
    const _newPar = {}
    for (const key in obj) {
      // 如果对象属性的值不为空，就保存该属性（这里我做了限制，如果属性的值为0，保存该属性。如果属性的值全部是空格，属于为空。）
      if ((obj[key] === 0 || obj[key]) && obj[key].toString().replace(/(^\s*)|(\s*$)/g, '') !== '') {
        // 记录属性
        _newPar[key] = obj[key]
      }
    }
    // 返回对象
    return _newPar
  }
  